﻿using UnityEngine;
using System.Collections;

public class mouvementMinionGentil : MonoBehaviour {
	

	public float transSpeed; // variable permettant de changer la vitesse de translation
	public int rentreSort = 1; //  permet de faire un choix entre rentrer et sortir le minion (0=immobile /1=sort / 2=rentre )
	public float outTime;
	public float timer;
	
	public static bool toucher; // indique que le minion à été touché
	
	public bool fin;
	
	// déclaration des sons
	public AudioClip tapeJaune;


	// Use this for initialization
	void Start () {
		fin = false;
		toucher = false;
	}
	
	// Update is called once per frame
	void Update () 
	{
		gestionVitesse ();
		translate();
		if (toucher == false)
		{
		clic ();
		}
		
		if (gestionMinion.niveau == 0)
		{
			Destroy(gameObject);
			gestionMinion.nbMinion--;
			gestionMinion.minion = false;
		}
	}
	
	
	//fait translater le minion 
	void translate ()
	{
	
		switch (rentreSort)
		{
			case 0 : 
				// permet de rester au minion dehors
				if (Time.time > timer)
				{
					rentreSort = 2;
				}
				break;
			
			case 1:
				//fait sortir le minion
				if (transform.position.y < 33)
				{
					transform.Translate(Vector3.forward * transSpeed);
				}
				else 
				{
					rentreSort=0;
					timer = outTime+Time.time;
				}
				break;	
			
			case 2:
				//fait rentrer le minion
				if (transform.position.y > -12)
				{		
					transform.Translate(Vector3.back * transSpeed);
				}
				else 
				{
					if (fin == false)
					{
						fin = true;
						Destroy(gameObject);
						gestionMinion.nbMinion--;
						
						if (toucher == false)
						{
							// permet d'incrémenter qu'une fois le compteur
							gestionAffichage.actuScore = true;
							//gestionMinion.minionGentilSortie++;
						}
						gestionMinion.minion = false;
						//Debug.Log("actu score"+gestionAffichage.actuScore);
					}
				}
				break;
		}
	}
	
	void gestionVitesse ()
	{
		
		if (gestionAffichage.etape == "niveau1")
		{
			// gère la vitesse de translation
			transSpeed = (Mathf.Log((Time.time-gestionMinion.timerVitesse)+1)/4); 
			
			// calcul du temps resté en haut
			outTime = 1/(transSpeed*2);
			
			//Debug.Log(transSpeed);
		}
		
		if (gestionAffichage.etape == "niveau2")
		{
			// gère la vitesse de translation
			transSpeed = (Mathf.Log((Time.time-gestionMinion.timerVitesse)+1)*2/6); 
			
			// calcul du temps resté en haut
			outTime = 1/(transSpeed*2);
			
			//Debug.Log(transSpeed);
		}
	}
	
	void clic () {
		
		// vérifie si l'on a cliqué sur un minion
		 if (Input.GetMouseButtonDown(0)) 
		{
            RaycastHit hit;
            Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
            if (Physics.Raycast(ray, out hit))
			{
				//Debug.Log ("hit something");
				
				audio.PlayOneShot(tapeJaune);
				
                if (hit.collider != null)
				{
                    hit.collider.enabled = false; // permet de cliquer qu'une fois sur l'objet
					
				}
				
				toucher = true;
				
				// fait redescendre le minion
				rentreSort =2;

				// incrémente et actualise le score
				//gestionMinion.minionGentilSortie++;
				gestionAffichage.score--;
				gestionAffichage.actuScore = true;

			}
		}
		
		
	}
	
	
	
	
	
}
